#!/bin/bash

# Gabriel L. Somlo - 2004,2005

# QueryTracker is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
#
# QueryTracker is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with QueryTracker; see the file COPYING.  If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.  


FORMHEAD="
<HTML>
 <HEAD>
  <TITLE>QueryTracker: Create New Account</TITLE>
 </HEAD>
 <BODY>
  <H1>QueryTracker: Create New Account</H1>
  <HR>
  <H3>
"
FORMTAIL="
   <FORM action="http://foober.acns.colostate.edu/QueryTracker/newacct.cgi" method="post">
    <table>
    <tr><td>Enter New Username:</td>
    <td><input type="text" size="15" maxlength="15" name="username"></td></tr>
    <tr><td>Enter Password:</td>
    <td><input type="password" size="8" maxlength="8" name="passwd1"></td></tr>
    <tr><td>Re-type Password:</td>
    <td><input type="password" size="8" maxlength="8" name="passwd2"></td></tr>
    <tr colspan=2><td><input type="submit" value="Create">
    <input type="reset" value="Clear"></td></tr>
    </table>
   </FORM></P>
  </H3>
  <HR>
 </BODY>
</HTML>
"

echo "Content-type: text/html"
echo

read INPUT

if [ ! ${INPUT} ]; then
  echo "${FORMHEAD}"
  echo "${FORMTAIL}"
  exit 0
fi

USERNAME=$(echo ${INPUT} | cut -d\& -f1 | cut -d= -f2)
PASSWD1=$(echo ${INPUT} | cut -d\& -f2 | cut -d= -f2)
PASSWD2=$(echo ${INPUT} | cut -d\& -f3 | cut -d= -f2)

# check if user already exists
if [ $(grep -F ${USERNAME}: auth/.htpasswd) ]; then
## FIXME: also check if username starts with "preload-" and reject ! 
  echo "${FORMHEAD}"
  echo "<font color=\"red\">User \"${USERNAME}\" already exists: Please pick another name!</font></P>"
  echo "${FORMTAIL}"
  exit 0
fi

# check if password matches
if [ "${PASSWD1}" != "${PASSWD2}" ]; then
  echo "${FORMHEAD}"
  echo "<font color=\"red\">Password mismatch: Please try again!</font></P>"
  echo "${FORMTAIL}"
  exit 0
fi

# append new user to password file...
./pwcrypt.pl ${USERNAME} ${PASSWD1} >> auth/.htpasswd
# ... and redirect to login page
cat login.html
exit 0
