#!/usr/bin/perl -w

# Gabriel L. Somlo - 2004,2005

# QueryTracker is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.
#
# QueryTracker is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with QueryTracker; see the file COPYING.  If not, write to the Free
# Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.  


if( @ARGV != 2 ) {
  print( "\n   Usage: $0 <username> <password>\n\n" );
  print( "generates .htpassword entry for specified user/password combination\n" );
  exit( 0 );
}

$username = $ARGV[0];
$clearpw = $ARGV[1];

@saltset = ( 'a'..'z', 'A'..'Z', '0'..'9', '.', '/' );

$salt = $saltset[int(rand(64))] . $saltset[int(rand(64))];
$cryptpw = crypt( $clearpw, $salt );
print( "$username:$cryptpw\n" );	
